//  Listing 9.3. Przykad uycia destruktora do zwrotu pamici przydzielonej na stercie dla obiektu z nazw i obiektu bez nazwy

#include <iostream>
using namespace std;

struct Name 
{
char *contents;       	// publiczny wskanik do dynamicznej pamici
Name (char* name);
void show_name();
~Name();     		// destruktor, by wyeliminowa "memory leak", czyli wyciek pamici
}; 

Name::Name(char* name) 	// konstruktor konwertujcy
{ 
int len = strlen(name); 	// liczba znakw
contents = new char[len+1]; 	// przydzia dynamicznej pamici
if (contents == NULL) 		// nie udao si
{ 
  cout << "Brak pamici.\n"; exit(1); // wyjcie "awaryjne"
} 
strcpy(contents, name); 	// standardowe dziaanie
cout << "obiekt utworzony: " << contents << endl; 
}                         	// komunikat diagnostyczny

void Name::show_name()
{ 
cout <<contents << "\n"; 
}

Name::~Name()                   // destruktor
{ 
cout << "obiekt usunity: ";
cout << contents << endl;       // komunikat diagnostyczny
delete contents; 		// ten operator usuwa pami na stercie
} 				// a nie sam wskanik 'contents'

void Client()
{ 
Name n1("Jones"); 		// wywoanie konstruktora konwertujcego
Name *p = new Name("Smith"); 	// wywoanie konstruktora konwertujcego
n1.show_name(); p->show_name();
delete p; 			// destruktor obiektu wskazywanego przez p
} 				// usuwany jest p, wywoanie destruktora obiektu n1

int main() 			// przekazanie odpowiedzialnoci funkcji - serwerowi
{ 
  Client();
  return 0;
}
